//#include "Precompiled.h"
//------------------------------------------------------------------------------
// (c) 01-2002 Gottfried Chen
//------------------------------------------------------------------------------

#include "water/StatisticalWater.h"
//#include "water/fft.h"
//#include "kernel/ntypes.h"


//------------------------------------------------------------------------------
// inline const Fft2D* StatisticalWater::getFft() const
const Fft2D* StatisticalWater::getFft() const
//------------------------------------------------------------------------------
{
    return mFft;
}


//------------------------------------------------------------------------------
StatisticalWater::StatisticalWater(unsigned int xPower, unsigned int yPower,
                                   float a, const vector2& wind,
                                   float xWorld, float yWorld) :
//------------------------------------------------------------------------------
mA(a),
mWind(wind),
m2PiByXWorld((6.283185307179586476925286766559f)/xWorld),
m2PiByYWorld((6.283185307179586476925286766559f)/yWorld),
mXPower(xPower),
mYPower(yPower)
{
	mXSize =xPower;
	mYSize = yPower;
 
    mH0 = n_new(nComplex[mYSize*mXSize]);
    mh = n_new(nComplex[mYSize*mXSize]);
	mFft = n_new(Fft2D(xPower, yPower));

    calculateH0();
}

//------------------------------------------------------------------------------
StatisticalWater::~StatisticalWater()
//------------------------------------------------------------------------------
{
//	n_printf("stat~\n");
    n_delete_array(mH0);
    n_delete_array(mh);
	n_delete(mFft);
//	n_printf("stat~\n");
}


//------------------------------------------------------------------------------
const nComplex* StatisticalWater::getMap() const
//------------------------------------------------------------------------------
{
    return mh;
}

//------------------------------------------------------------------------------
unsigned int StatisticalWater::getXSize() const
//------------------------------------------------------------------------------
{
    return mXSize;
}

//------------------------------------------------------------------------------
unsigned int StatisticalWater::getYSize() const
//------------------------------------------------------------------------------
{
    return mYSize;
}


//------------------------------------------------------------------------------
void StatisticalWater::store(unsigned int index, const vector2&, float, const nComplex& result)
//------------------------------------------------------------------------------
{
    mh[index] = result;
}
#ifdef __VC__
#pragma optimize("agt", on)
#endif
//------------------------------------------------------------------------------
void StatisticalWater::transformToTime()
//------------------------------------------------------------------------------
{
//n_printf("stati trans\n");
    getFft()->calculate(mh);
    
    unsigned int yLine(0);
    for (unsigned int y = 0; y<mYSize; ++y)
    {
        yLine = y*mXSize;
        for (unsigned int x = 0; x<mXSize; ++x)
        {
            // The neg1Pow term results from shifting the sum index from [-N/2, N)
            // to [0, N)
            mh[yLine+x] *= float(neg1Pow(x+y));
        }
    }
}

#ifdef __VC__
#pragma optimize("agt", on)
#endif
//------------------------------------------------------------------------------
void StatisticalWater::calculateH0()
//------------------------------------------------------------------------------
{    
    unsigned int yLine;
	nComplex zeta;
//n_printf("cal h0 ");
	for (unsigned int y = 0; y<mYSize; ++y)
    {
        yLine = y*mXSize;
        for (unsigned int x = 0; x<mXSize; ++x)
        {
            zeta.set(gaussian(), gaussian());
            mH0[yLine+x] = zeta*INV_SQRT_TWO*
                n_sqrt(phillips(mA, vector2(indexToWorldX(x), indexToWorldY(y)), mWind));

        }
    }
//n_printf("cal h0\n");
}




#ifdef __VC__
#pragma optimize("agt", on)
#endif
//------------------------------------------------------------------------------
void StatisticalWater::update(const double& t)
//------------------------------------------------------------------------------
{
    float kl;
    float wkt; // x(k)*t
    nComplex ep, em; // exp(i*w(k)*t), exp(-i*w(k)*t)
    unsigned int yLineMirr; // yLine mirrored at mYSize/2
    unsigned int kNegIndex; // Array index of vector -k

    nComplex result;
    unsigned int yLine;
    vector2 k;

	// We need only to loop over the half map, because the rest of
    // the values gets calculated by taking the conjugate.
    unsigned int yHalf = mYSize/2 + 1;
    for (unsigned int y = 0; y<yHalf; ++y)
    {
        yLine = y*mXSize;
        // Mirror the y line index for calculation of -k
        // The line below evalutes yLineMirr = y == 0 ? 0 : (mYSize-y)*mXSize;
        // by wrapping the heightmap, since it is periodic.
        yLineMirr = mod(mYSize-y, mYSize)*mXSize;
        for (unsigned int x = 0; x<mXSize; ++x)
        {
            k = vector2(indexToWorldX(x), indexToWorldY(y));
            kl = k.len();
      
            wkt = n_sqrt(kl*G)*t;
           
            ep = nComplex(n_cos(wkt), n_sin(wkt));
            em = ep.conj();

            // yLineMirr+mXSize-x is the index of -k
            kNegIndex = yLineMirr + mod(mXSize-x, mXSize);
  
            // This is h~(K, t) from the Tessendorf paper.
            result = (mH0[yLine+x]) * ep +  (mH0[kNegIndex])->conj() * em;
//n_printf("%f ",result.imag());
//n_printf("co%f ",conj(result).imag());
            // Store it for later transformation
            store(yLine+x, k, kl, result);
            // h~(-K) = conj(h~(K))
            if (y != yHalf-1)
            {
                store(kNegIndex, -k, kl, result.conj());
            }
        }
    }

    // Do the FFT to the time domain.
    transformToTime();
}