//------------------------------------------------------------------------------
//  (C)	2002-2004	tom@3d-inferno.com
//------------------------------------------------------------------------------
#include "water/nwaternode.h"
#include "kernel/npersistserver.h"

//static void n_setsize(void* slf, nCmd* cmd);
//static void n_getsize(void* slf, nCmd* cmd);
//static void n_setreadonly(void* slf, nCmd* cmd);
//static void n_getreadonly(void* slf, nCmd* cmd);
//static void n_setcastshadow(void* slf, nCmd* cmd);
//static void n_getcastshadow(void* slf, nCmd* cmd);
//static void n_setamplitude(void* slf, nCmd* cmd);
//static void n_getamplitude(void* slf, nCmd* cmd);
static void n_getheight(void* slf, nCmd* cmd);
static void n_gettype(void* slf, nCmd* cmd);
static void n_settype(void* slf, nCmd* cmd);

//------------------------------------------------------------------------------
/**
    @scriptclass
    nwaternode
    
    @superclass
    nmaterialnode

    @classinfo
    A nwaternode is a render instance of a water algorithm mesh of a certian sample
	size. 
*/
void
n_initcmds(nClass* clazz)
{
    clazz->BeginCmds();
//	clazz->AddCmd("v_setsize_ii", 'SSZE', n_setsize);
//	clazz->AddCmd("ii_getsize_v", 'GSZE', n_getsize);
	clazz->AddCmd("f_getheight_ff", 'GHGT', n_getheight);
	clazz->AddCmd("i_gettype_v", 'GTYP', n_gettype);
	clazz->AddCmd("b_settype_i", 'STYP', n_settype);
    clazz->EndCmds();
}


//------------------------------------------------------------------------------
/**
    @cmd
    getheight

    @input
    ff

    @output
    f

    @info
    returns the height for the currentlly running algorithm at the given position
	relative to the nwaternode position (localspcae of this node)
*/
static void n_getheight(void* slf, nCmd* cmd)
{
    nWaterNode* self = (nWaterNode*) slf;
    cmd->Out()->SetF(self->GetHeight(cmd->In()->GetF(), cmd->In()->GetF()));
}


//------------------------------------------------------------------------------
/**
    @cmd
    settype

    @input
    i

    @output
    v

    @info
    sets the type of water algorithm to be displayed. Use 0 for statistical
	water, 1 for choppy water and 2 for gerstner water algorithm.
*/
static void n_settype(void * slf, nCmd* cmd)
{
	nWaterNode* self = (nWaterNode*) slf;
	cmd->Out()->SetB(self->SetType(cmd->In()->GetI()));
}


//------------------------------------------------------------------------------
/**
    @cmd
    gettype

    @input
    v

    @output
    i

    @info
    returns the type of water algoritm used in this node. See settype for returnable
	types.
*/
static void n_gettype(void * slf, nCmd* cmd)
{
	nWaterNode* self = (nWaterNode*) slf;
	cmd->Out()->SetI(self->GetType());
}



//------------------------------------------------------------------------------
/**
	Saves settings of current node

    @param  fs  pointer to persistence server.
    @return             success or failure
*/
bool
nWaterNode::SaveCmds(nPersistServer* fs)
{
    if (nMaterialNode::SaveCmds(fs))
    {
		nCmd *cmd;
		
		//--- settype ---
		if (this->GetType()>=0)
		{
			cmd = fs->GetCmd(this, 'STYP');
			cmd->In()->SetI(this->GetType());
			fs->PutCmd(cmd);
		}	
		///@todo add more commands for persistence

        return true;
    }
    return false;
}