//------------------------------------------------------------------------------
//  (C)	2002-2004	tom@3d-inferno.com
//------------------------------------------------------------------------------
#include "water/nwaternode.h"
#include "gfx2/nmesh2.h"


nNebulaScriptClass(nWaterNode, "nmaterialnode");
//------------------------------------------------------------------------------
/**
    Loads materialnode resources, water is not initialized at this point.

    @return                 true if success
*/
bool nWaterNode::LoadResources()
{
	if(nMaterialNode::LoadResources())
	{
		return true;
	}
	return false;
}
//------------------------------------------------------------------------------
/**
    Initialize mesh reference through lookup

    @return                 true if success
*/
bool nWaterNode::Load()
{
	char iname[256];
	sprintf(iname,"nWaterNode_%d_%d",this->m_Type,SampleSize);

	if(this->ref_Server.isvalid())
	{
		this->ref_Server->Update();
	
		this->ref_vb = nGfxServer2::Instance()->NewMesh(iname);
		if(this->ref_vb.isvalid())
		{
			return true;
		}
	}
	return false;
}
//------------------------------------------------------------------------------
/**
    Unload material and mesh resources
*/
void nWaterNode::UnloadResources()
{
	nMaterialNode::UnloadResources();
	// release mesh
	if(this->ref_vb.isvalid())
	{
		this->ref_vb->Release();
		this->ref_vb.invalidate();
	}
}
//------------------------------------------------------------------------------
/**
    Render resource mesh node to scene.

    @param  sceneServer      pointer to scene server
	@param  renderContext	 pointer to render context
    @return                  true if success
*/
bool nWaterNode::RenderGeometry(nSceneServer* sceneServer, nRenderContext* renderContext)
{
//	return false;
	n_assert(sceneServer);
    n_assert(renderContext);

    // update server mesh call
	if(this->ref_Server.isvalid())
		this->ref_Server->Update();

	// check for type changes
	if(this->m_Nt != this->m_Type)
	{
		if(this->ref_Server.isvalid())
		{
			this->ref_Server->RemWaterRef(this->m_Type);
			this->ref_Server->AddWaterRef(this->m_Nt);
			this->m_Type = this->m_Nt;
			if (this->ref_vb.isvalid()) 
			{
				this->ref_vb->Release();
				this->ref_vb.invalidate();
			}
		}
	}

	// render or load
    if(this->ref_vb.isvalid() && this->ref_vb->IsValid())//isvalid())
	{
		// render the mesh in normal mode (always at stream 0)
		nGfxServer2::Instance()->SetMesh(this->ref_vb);

		// set the vertex and index range
		const nMeshGroup& curGroup = this->ref_vb->GetGroup(0);
		nGfxServer2::Instance()->SetVertexRange(curGroup.GetFirstVertex(), curGroup.GetNumVertices());
		nGfxServer2::Instance()->SetIndexRange(curGroup.GetFirstIndex(), curGroup.GetNumIndices());
		nGfxServer2::Instance()->DrawIndexedNS(nGfxServer2::TriangleList);
		return true;
	}
	else
	{
		Load();
	}
	
	return false;
}
