//------------------------------------------------------------------------------
//  (C)	2002-2004	tom@3d-inferno.com
//------------------------------------------------------------------------------
#include "water/nwaterserver.h"
#include "kernel/npersistserver.h"


static void n_getrefs(void* slf, nCmd* cmd);
static void n_setfps(void* slf, nCmd* cmd);
static void n_getfps(void* slf, nCmd* cmd);
static void n_setchopp(void* slf, nCmd* cmd);
static void n_getchopp(void* slf, nCmd* cmd);

//------------------------------------------------------------------------------
/**
    @scriptclass
    nwaterserver
    
    @superclass
    nroot

    @classinfo
    The nWaterServer lives at /sys/servers/water and provides different water algorithms
	which can then be instanciated by nWaterNodes. 
	At the moment the following algorithms are provieded:
	Statistical Water
	Choppy Water
	Gerstner Water
*/
void
n_initcmds(nClass* clazz)
{
    clazz->BeginCmds();
    clazz->AddCmd("v_setfps_i", 'SFPS', n_setfps);
	clazz->AddCmd("i_getfps_v", 'GFPS', n_getfps);
	//clazz->AddCmd("i_getrefs_v", 'GERF', n_getrefs);
    clazz->AddCmd("f_getchopp_v", 'GCHP', n_getchopp);
	clazz->AddCmd("v_setchopp_f", 'SCHP', n_setchopp);
	clazz->EndCmds();
}

//------------------------------------------------------------------------------
/**
    @cmd
    setfps

    @input
    v

    @output
    i

    @info
    Sets the update frequency of the costly algorithm updates. Sets how many frames
	will pass before the water is actuallized.
*/
static
void
n_setfps(void* slf, nCmd* cmd)
{
    nWaterServer* self = (nWaterServer*) slf;
    self->SetFPS(cmd->In()->GetI());
}

//------------------------------------------------------------------------------
/**
    @cmd
    getfps

    @input
    i

    @output
    v

    @info
    Returns the update frequency of the costly algorithm updates. Returns how many frames
	will pass before the water is actuallized.
*/
static void n_getfps(void* slf, nCmd* cmd)
{
    nWaterServer* self = (nWaterServer*) slf;
    cmd->Out()->SetI(self->GetFPS());
}



//------------------------------------------------------------------------------
/**
    @cmd
    setchopp

    @input
    f

    @output
    v

    @info
    Sets the choppyness factor used for choppy waves water algorithms. A value
	around -0.15 is quite good.
*/
static
void
n_setchopp(void* slf, nCmd* cmd)
{
    nWaterServer* self = (nWaterServer*) slf;
    self->SetChopp(cmd->In()->GetF());
}

//------------------------------------------------------------------------------
/**
    @cmd
    getchopp

    @input
    v

    @output
    f

    @info
    Returns the choppyness factor used on choppy water.
*/
static void n_getchopp(void* slf, nCmd* cmd)
{
    nWaterServer* self = (nWaterServer*) slf;
    cmd->Out()->SetF(self->GetChopp());
}

//------------------------------------------------------------------------------
/**
	Saves nWaterServer settings for persistence

	@param fs	pointer to persistence server

	@return		true on success
*/
bool
nWaterServer::SaveCmds(nPersistServer* fs)
{
    if (nRoot::SaveCmds(fs))
    {
		nCmd *cmd;
		
		//--- setfps ---
		if (this->GetFPS())
		{
			cmd = fs->GetCmd(this, 'SFPS');
			cmd->In()->SetI(this->GetFPS());
			fs->PutCmd(cmd);
		}
		//--- setchoppyness ---
		if (this->GetChopp() != 0.0f)
		{
			cmd = fs->GetCmd(this, 'SCHP');
			cmd->In()->SetF(this->GetChopp());
			fs->PutCmd(cmd);
		}
        return true;
    }
    return false;
}
